<?php
header('Content-Type: application/json');

// Vérifier que la requête est en POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit;
}

// Récupérer et nettoyer le numéro WhatsApp
$whatsapp = trim($_POST['whatsapp'] ?? '');

// Validation du numéro
if (empty($whatsapp)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Le numéro WhatsApp est requis']);
    exit;
}

// Nettoyer le numéro (garder seulement les chiffres et le +)
$whatsapp = preg_replace('/[^0-9+]/', '', $whatsapp);

// Validation du format (au moins 8 chiffres après le + ou sans +)
$digitsOnly = preg_replace('/[^0-9]/', '', $whatsapp);
if (strlen($digitsOnly) < 8) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Le numéro WhatsApp semble invalide']);
    exit;
}

// Préparer les données
$data = [
    'whatsapp' => $whatsapp,
    'timestamp' => date('Y-m-d H:i:s'),
    'ip' => $_SERVER['REMOTE_ADDR'] ?? 'unknown'
];

// Chemin du fichier de sauvegarde
$dataDir = __DIR__ . '/data';
if (!is_dir($dataDir)) {
    mkdir($dataDir, 0755, true);
}

$filePath = $dataDir . '/whatsapp-subscriptions.json';

// Charger les données existantes
$existingData = [];
if (file_exists($filePath)) {
    $fileContent = file_get_contents($filePath);
    $existingData = json_decode($fileContent, true) ?: [];
}

// Vérifier si le numéro existe déjà (pour éviter les doublons récents - dans les 24h)
$recentEntry = false;
$oneDayAgo = date('Y-m-d H:i:s', strtotime('-1 day'));
foreach ($existingData as $entry) {
    if (isset($entry['whatsapp']) && 
        preg_replace('/[^0-9]/', '', $entry['whatsapp']) === $digitsOnly &&
        isset($entry['timestamp']) && 
        $entry['timestamp'] > $oneDayAgo) {
        $recentEntry = true;
        break;
    }
}

if ($recentEntry) {
    // Numéro déjà enregistré récemment, mais on retourne un succès pour ne pas frustrer l'utilisateur
    echo json_encode([
        'success' => true, 
        'message' => 'Votre numéro a déjà été enregistré récemment. Merci !',
        'duplicate' => true
    ]);
    exit;
}

// Ajouter les nouvelles données
$existingData[] = $data;

// Sauvegarder dans le fichier
$jsonData = json_encode($existingData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
if (file_put_contents($filePath, $jsonData, LOCK_EX) === false) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la sauvegarde']);
    exit;
}

// Retourner un succès
echo json_encode([
    'success' => true, 
    'message' => 'Votre numéro a été enregistré avec succès !'
]);
?>
